/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: EcatEsm_Functionlist.h $

    $GlobalRev: 63951 $
    $Version: V2.5.42.0 $
    $Packaged: 2016-09-12 15:21 $

   Targets:
    rcX          : yes

   Description:

    Ecat Esm
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
      8        23.03.2007  sb
        Updated source header
        Corrected task entry function

      1        13.06.2005  SB       1.000
        Created

**************************************************************************************/
#ifndef __ECAT_ESM_FUNCTIONLIST_H
#define __ECAT_ESM_FUNCTIONLIST_H

/***************************************************************************************/
/* Ecat Esm function list, prototyes */

TLR_RESULT  TaskExit_EcatEsm (void* pvRsc);

void    TaskEnter_EcatEsm(void* pvInit);


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_ESM_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_ESM_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_ESM_STARTUPPARAMETER_Ttag  ECAT_ESM_STARTUPPARAMETER_T;


/******************************************************************************/
/** @name Init Parameter for ESM to select available tasks to be waited for
 *
 * Defines all wait bits that the ESM task has to wait for
 * @{
 */

#ifndef __ECS_PUBLIC_H
struct ECAT_READYWAIT_STATUS_tag {
  TLR_UINT32 uReadyWaitBits;
};

typedef struct ECAT_READYWAIT_STATUS_tag ECAT_READYWAIT_STATUS_T;

/** Application-definable ready wait bits */
#define ECAT_READYWAIT_APPLICATION_MASK   (0xfff00000)
/** Stack associated ready wait bits */
#define ECAT_READYWAIT_STACK_MASK         (0x000fffff)

/** Base stack ready wait bits */
#define ECAT_READYWAIT_MBX                (0x00000001)

/** CoE stack ready wait bits */
#define ECAT_READYWAIT_COE                (0x00000004)
#define ECAT_READYWAIT_COE_PDO_STAGE1     (0x00000008)
#define ECAT_READYWAIT_COE_SDO            (0x00000010)
#define ECAT_READYWAIT_COE_PDO_STAGE2     (0x00000020)

#define ECAT_READYWAIT_COE_PDO \
  (ECAT_READYWAIT_COE_PDO_STAGE1| \
   ECAT_READYWAIT_COE_PDO_STAGE2)

/** EoE stack ready wait bits */
#define ECAT_READYWAIT_EOE                (0x00000040)

/** FoE stack ready wait bits */
#define ECAT_READYWAIT_FOE                (0x00000080)

/** VoE stack ready wait bits */
#define ECAT_READYWAIT_VOE                (0x00000100)

/** SoE stack ready wait bits */
#define ECAT_READYWAIT_SOE_SSC            (0x00000800)
#define ECAT_READYWAIT_SOE_IDN            (0x00001000)


#define ECAT_READYWAIT_COMPLETED          (0xffffffff)

/** cyclic task handlers */
#define ECAT_READYWAIT_CYCLIC_STATIC      (0x00002000)
#define ECAT_READYWAIT_CYCLIC_DYNAMIC     (0x00004000)
#define ECAT_READYWAIT_CYCLIC_DPM         (0x00008000)


#define ECAT_READYWAIT_BASE_STACK \
  ECAT_READYWAIT_MBX

#define ECAT_READYWAIT_COE_STACK \
  (ECAT_READYWAIT_COE | \
  ECAT_READYWAIT_COE_SDO)

#define ECAT_READYWAIT_EOE_STACK \
  ECAT_READYWAIT_EOE

#define ECAT_READYWAIT_VOE_STACK \
  ECAT_READYWAIT_VOE

#define ECAT_READYWAIT_FOE_STACK \
  ECAT_READYWAIT_FOE

#define ECAT_READYWAIT_SOE_STACK \
  (ECAT_READYWAIT_SOE_SSC |     \
  ECAT_READYWAIT_SOE_IDN)

/** app task definitions */
#define ECAT_READYWAIT_APP_TASK_1         (0x00100000)
#define ECAT_READYWAIT_APP_TASK_2         (0x00200000)
#define ECAT_READYWAIT_APP_TASK_3         (0x00400000)
#define ECAT_READYWAIT_APP_TASK_4         (0x00800000)
#define ECAT_READYWAIT_APP_TASK_5         (0x01000000)
#define ECAT_READYWAIT_APP_TASK_6         (0x02000000)
#define ECAT_READYWAIT_APP_TASK_7         (0x04000000)
#define ECAT_READYWAIT_APP_TASK_8         (0x08000000)
#define ECAT_READYWAIT_APP_TASK_9         (0x10000000)
#define ECAT_READYWAIT_APP_TASK_10        (0x20000000)
#define ECAT_READYWAIT_APP_TASK_11        (0x40000000)
#define ECAT_READYWAIT_APP_TASK_12        (0x80000000)
#endif
/** @} */

/******************************************************************************
 * @name EtherCAT SII init param block
 *
 * Defines the initialization data of the SII init param block
 * @{
 */
typedef struct ECAT_INITPARAM_SII_DATA_Ttag
{
  TLR_UINT32      ulVendorId;
  TLR_UINT32      ulProductCode;
  TLR_UINT32      ulRevisionNumber;
  TLR_UINT32      ulSerialNumber;
  TLR_UINT8       bPdiCfgSyncCfg;      /* parameter is ignored */
  TLR_UINT16      usSyncImpulseLength; /* parameter is ignored */
  TLR_UINT16      usSIICategorySize;
  TLR_UINT8*      pbSIICategoryData;
} ECAT_INITPARAM_SII_DATA_T;
/** @} */

#define ECAT_INITPARAM_PDI_CFG_SYNC0_OUTPUT           0x01
#define ECAT_INITPARAM_PDI_CFG_SYNC0_POLARITY         0x02
#define ECAT_INITPARAM_PDI_CFG_SYNC0_OUTPUT_EN        0x04
#define ECAT_INITPARAM_PDI_CFG_SYNC0_MAPPED_TO_IRQ    0x08
#define ECAT_INITPARAM_PDI_CFG_SYNC1_OUTPUT           0x10
#define ECAT_INITPARAM_PDI_CFG_SYNC1_POLARITY         0x20
#define ECAT_INITPARAM_PDI_CFG_SYNC1_OUTPUT_EN        0x40
#define ECAT_INITPARAM_PDI_CFG_SYNC1_MAPPED_TO_IRQ    0x80

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_ESM_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  /** Ready Wait bits to wait for until any AL control event will be accepted */
  ECAT_READYWAIT_STATUS_T           tReadyWaitBits;
  /** SII initialization data block */
  ECAT_INITPARAM_SII_DATA_T*        ptSiiData;
  /** size of EEPROM image */
  TLR_UINT32                        ulEepromSize;
  TLR_UINT16                        usMailboxSize;       /* 0 == default value, minimum configurable is 128 byte (1.. 127 will be increased to 128) (additionally, must be dword aligned) */
  TLR_UINT16                        usBootstrapMailboxSize; /* 0 == disabled, minimum configurable is 128 byte (1.. 127 will be increased to 128) (additionally, must be dword aligned) */
};

/** @} */


/***************************************************************************************/
#endif /* #ifndef __ECAT_ESM_FUNCTIONLIST_H */
